# 🗺️ GeoTIFF → TMS 타일 변환 가이드

## 실행 환경

* **운영체제**: Windows
* **도구**: [OSGeo4W](https://trac.osgeo.org/osgeo4w/) 설치
* **GDAL**: OSGeo4W 기본 설치 후, 최신 버전(gdal 3.11.x) 별도 다운로드 및 사용
* **쉘**: OSGeo4W Shell

---

## 1️⃣ 좌표 변환 (EPSG:5187 → EPSG:3857)

```bash
gdalwarp -overwrite ^
  -s_srs EPSG:5187 -t_srs EPSG:3857 ^
  -srcnodata 0 -dstnodata 0 ^
  -r bilinear -of GTiff ^
  input.tif ^
  output.tif
```

### 옵션 설명

* **-s_srs EPSG:5187** : 원본 좌표계 (예: UTM-K)
* **-t_srs EPSG:3857** : 타겟 좌표계 (Web Mercator)
* **-srcnodata / -dstnodata** : 배경값 설정 (0 → 투명 처리)
* **-r bilinear** : 리샘플링 방식 (부드러운 영상 보간)
* **-of GTiff** : 출력 포맷을 GeoTIFF로 지정

---

## 2️⃣ GeoTIFF → TMS 타일 변환

```bash
python C:\gdal-3.11.4\swig\python\gdal-utils\scripts\gdal2tiles.py ^
  -r bilinear ^
  -z 16-21 ^
  -s EPSG:3857 ^
  -w openlayers ^
  --tmscompatible ^
  --tiledriver=JPEG ^
  "C:\Users\ASUS\Desktop\UJDRN\transform_3857\UJDRN0002.tif" ^
  "C:\Users\ASUS\Desktop\UJDRN\tiles\UJDRN\UJDRN0002"
```

### 옵션 설명

* **-z 16-21** : 생성할 줌 레벨 범위
* **-r bilinear** : 타일 리샘플링 방식
* **-s EPSG:3857** : 입력影 좌표계 지정 (미리 변환한 경우 생략 가능)
* **-w openlayers** : 결과 확인용 HTML(OpenLayers 뷰어) 생성

  * HTML이 필요 없으면 `-w none`
* **--tmscompatible** : TMS 표준(Z/Y/X 구조) 맞춤
* **--tiledriver=JPEG** : 타일 포맷을 JPEG으로 출력 (기본값: PNG)
* **입력 파일** : 변환된 GeoTIFF
* **출력 디렉토리** : 타일 저장 경로

---

## 3️⃣ 결과물

* **디렉토리 구조**

  ```
  └─ UJDRN0002/
     ├─ 16/
     │   ├─ 34000/
     │   │   ├─ 23981.jpg
     │   │   └─ ...
     ├─ 17/
     ├─ ...
     └─ openlayers.html
  ```
* **타일 파일** : JPEG (Z/Y/X 구조)
* **뷰어 파일** : `openlayers.html`에서 바로 확인 가능

---

👉 이렇게 하면 **Windows + OSGeo4W 환경에서도 최신 GDAL을 활용해 GeoTIFF를 고품질 JPEG TMS 타일**로 변환할 수 있습니다.

---

혹시 제가 위 내용을 **프로젝트 위키용 Markdown 템플릿**으로 더 간결하게 정리해드릴까요, 아니면 지금처럼 옵션 설명을 길게 풀어 쓰는 게 더 필요하실까요?
